/*
 * Decompiled with CFR 0.152.
 */
package org.acm.seguin.tools.install;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import org.acm.seguin.awt.ExceptionPrinter;
import org.acm.seguin.util.FileSettings;
import org.acm.seguin.util.MissingSettingsException;

public class RefactoryStorage {
    private HashMap map = new HashMap();

    public RefactoryStorage() {
        this.load();
    }

    public int getValue(String key) {
        Object obj = this.map.get(this.normalize(key));
        if (obj == null) {
            return 1000;
        }
        return (Integer)obj;
    }

    public void addKey(String key, int value) {
        this.map.put(this.normalize(key), new Integer(value));
    }

    public void store() {
        try {
            PrintWriter output = new PrintWriter(new FileWriter(new File(FileSettings.getRefactorySettingsRoot(), "refactory.settings")));
            Iterator iter = this.map.keySet().iterator();
            while (iter.hasNext()) {
                String next = (String)iter.next();
                output.println(next + "=" + this.map.get(next));
            }
            output.close();
        }
        catch (IOException ioe) {
            ExceptionPrinter.print(ioe, false);
        }
    }

    private String normalize(String input) {
        StringBuffer buffer = new StringBuffer();
        int ndx = 0;
        while (ndx < input.length()) {
            char ch = input.charAt(ndx);
            if (Character.isJavaIdentifierPart(ch) || ch == '.') {
                buffer.append(ch);
            } else {
                buffer.append('_');
            }
            ++ndx;
        }
        return buffer.toString();
    }

    private void load() {
        try {
            FileSettings settings = FileSettings.getRefactorySettings("refactory");
            Enumeration enumeration = settings.getKeys();
            while (enumeration.hasMoreElements()) {
                String next = (String)enumeration.nextElement();
                this.map.put(next, new Integer(settings.getInteger(next)));
            }
        }
        catch (MissingSettingsException missingSettingsException) {
            // empty catch block
        }
    }
}

