/*
 * Decompiled with CFR 0.152.
 */
package org.acm.seguin.tools.install;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import javax.swing.JPanel;
import org.acm.seguin.tools.install.Divider;
import org.acm.seguin.tools.install.SettingPanel;

public abstract class SettingGroup
extends JPanel {
    private ArrayList dividerList = new ArrayList();
    private String groupName;
    private LinkedList list;

    public SettingGroup(String value) {
        this.setGroupName(value);
        this.list = new LinkedList();
    }

    public void setGroupName(String value) {
        this.groupName = value;
    }

    public String getGroupName() {
        return this.groupName;
    }

    public void generateSetting(PrintWriter output) {
        Iterator iter = this.list.iterator();
        while (iter.hasNext()) {
            SettingPanel next = (SettingPanel)iter.next();
            next.generateSetting(output);
        }
    }

    public void reload() {
        Iterator iter = this.list.iterator();
        while (iter.hasNext()) {
            SettingPanel next = (SettingPanel)iter.next();
            next.reload();
        }
    }

    protected void add(SettingPanel panel, GridBagConstraints constraints) {
        this.add(panel, constraints, true);
    }

    protected void add(SettingPanel panel, GridBagConstraints constraints, boolean addToPanel) {
        this.list.add(panel);
        if (addToPanel) {
            super.add((Component)panel, constraints);
        }
    }

    protected Divider createDivider() {
        Divider divider = new Divider();
        this.dividerList.add(divider);
        return divider;
    }

    protected void updateDividers() {
        Dimension dim = this.getPreferredSize();
        int wide = (int)((double)dim.width * 0.8);
        Iterator iter = this.dividerList.iterator();
        while (iter.hasNext()) {
            Divider divider = (Divider)iter.next();
            divider.adjustSize(wide);
        }
    }
}

