/*
 * Decompiled with CFR 0.152.
 */
package org.acm.seguin.tools.install;

import java.awt.Font;
import java.awt.GridLayout;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.acm.seguin.util.FileSettings;
import org.acm.seguin.util.MissingSettingsException;

public abstract class SettingPanel
extends JPanel {
    private List descriptions = new ArrayList();
    private GridLayout gridLayout = new GridLayout(1, 1);
    private int items;
    protected static FileSettings bundle = null;
    protected static Font teletype = null;

    public SettingPanel() {
        this.setLayout(this.gridLayout);
        this.items = 0;
    }

    public abstract String getKey();

    public String getValue() {
        return this.getDefaultValue();
    }

    public String getDefaultValue() {
        if (bundle == null) {
            SettingPanel.init();
        }
        try {
            return bundle.getString(this.getKey());
        }
        catch (MissingSettingsException mse) {
            return this.getInitialValue();
        }
    }

    public void addDescription(String value) {
        this.addDescription(value, true);
    }

    public void addCodeDescription(String value) {
        this.addCodeDescription(value, true);
    }

    public void generateSetting(PrintWriter output) {
        this.printDescription(output);
        output.println(this.getKey() + "=" + this.getValue());
        output.println("");
    }

    protected abstract String getInitialValue();

    protected void addDescription(String value, boolean show) {
        this.descriptions.add(value);
        if (show) {
            this.addLabel(value);
        }
    }

    protected void addCodeDescription(String value, boolean show) {
        this.descriptions.add(value);
        if (show) {
            this.addCodeLabel(value);
        }
    }

    protected void incrItems() {
        ++this.items;
        this.gridLayout.setRows(this.items);
    }

    protected void printDescription(PrintWriter output) {
        Iterator iter = this.descriptions.iterator();
        while (iter.hasNext()) {
            output.println("# " + iter.next());
        }
    }

    protected void addLabel(String value) {
        ++this.items;
        this.gridLayout.setColumns(this.items);
        this.add(new JLabel(value));
    }

    protected void addCodeLabel(String value) {
        ++this.items;
        this.gridLayout.setColumns(this.items);
        JLabel temp = new JLabel(value);
        temp.setFont(teletype);
        this.add(temp);
    }

    private static synchronized void init() {
        if (bundle == null) {
            bundle = FileSettings.getRefactoryPrettySettings();
            teletype = new Font("monospaced", 0, 12);
        }
    }

    public abstract void reload();
}

