/*
 * Decompiled with CFR 0.152.
 */
package org.acm.seguin.tools.install;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.Comparator;
import javax.swing.JLabel;
import javax.swing.border.BevelBorder;
import javax.swing.border.EtchedBorder;
import org.acm.seguin.awt.OrderableList;
import org.acm.seguin.tools.install.AlphabeticalOrderPanel;
import org.acm.seguin.tools.install.BeanOrderPanel;
import org.acm.seguin.tools.install.FinalOrderPanel;
import org.acm.seguin.tools.install.GetterSetterOrderPanel;
import org.acm.seguin.tools.install.InitializerOrderPanel;
import org.acm.seguin.tools.install.ProtectionOrderPanel;
import org.acm.seguin.tools.install.SettingPanel;
import org.acm.seguin.tools.install.SortSettingPanel;
import org.acm.seguin.tools.install.StaticOrderPanel;
import org.acm.seguin.tools.install.TypeOrderPanel;

class SortControlSettingPanel
extends SettingPanel {
    private OrderableList list;
    private EtchedBorder etch = new EtchedBorder();
    private BevelBorder bevel = new BevelBorder(0);
    private GridBagConstraints constraints;
    private SortSettingPanel[] data;

    public SortControlSettingPanel() {
        this.setLayout(new GridBagLayout());
        this.constraints = new GridBagConstraints();
        this.constraints.gridx = 0;
        this.constraints.gridy = -1;
        this.constraints.gridwidth = 1;
        this.constraints.gridheight = 1;
        this.constraints.weightx = 1.0;
        this.constraints.weighty = 1.0;
        this.constraints.anchor = 17;
        this.constraints.fill = 0;
        this.constraints.insets = new Insets(0, 0, 0, 0);
        this.constraints.ipadx = 0;
        this.constraints.ipady = 0;
        this.addDescription("The following controls the order of methods, fields,");
        this.addDescription("classes, etc inside a class.");
        this.addControl();
    }

    public String getKey() {
        return "sort";
    }

    public void addControl() {
        this.data = new SortSettingPanel[]{new TypeOrderPanel(), new GetterSetterOrderPanel(), new FinalOrderPanel(), new ProtectionOrderPanel(), new StaticOrderPanel(), new BeanOrderPanel(), new AlphabeticalOrderPanel(), new InitializerOrderPanel()};
        Arrays.sort(this.data, new ComparePanels());
        this.list = new OrderableList(this.data, null);
        ++this.constraints.gridy;
        this.add((Component)this.list, this.constraints);
        int ndx = 0;
        while (ndx < this.data.length) {
            ++this.constraints.gridy;
            this.add((Component)this.data[ndx], this.constraints);
            ++ndx;
        }
    }

    public void generateSetting(PrintWriter output) {
        this.printDescription(output);
        Object[] data = this.list.getData();
        int current = 1;
        int ndx = 0;
        while (ndx < data.length) {
            SortSettingPanel next = (SortSettingPanel)data[ndx];
            if (next.isSortEnabled()) {
                next.generateSetting(output, current);
                ++current;
            }
            ++ndx;
        }
        int ndx2 = 0;
        while (ndx2 < data.length) {
            SortSettingPanel next = (SortSettingPanel)data[ndx2];
            if (!next.isSortEnabled()) {
                next.generateSetting(output, current);
                ++current;
            }
            ++ndx2;
        }
    }

    protected void addLabel(String value) {
        ++this.constraints.gridy;
        this.add((Component)new JLabel(value), this.constraints);
    }

    protected String getInitialValue() {
        return "";
    }

    public void reload() {
        int ndx = 0;
        while (ndx < this.data.length) {
            this.data[ndx].setOrder(1000);
            ++ndx;
        }
        int ndx2 = 0;
        while (ndx2 < this.data.length) {
            this.data[ndx2].reload();
            ++ndx2;
        }
        Arrays.sort(this.data, new ComparePanels());
        this.list.resetModel(this.data);
    }

    private class ComparePanels
    implements Comparator {
        private ComparePanels() {
        }

        public int compare(Object obj1, Object obj2) {
            SortSettingPanel ssp1 = (SortSettingPanel)obj1;
            SortSettingPanel ssp2 = (SortSettingPanel)obj2;
            if (ssp1.getOrder() < ssp2.getOrder()) {
                return -1;
            }
            if (ssp2.getOrder() < ssp1.getOrder()) {
                return 1;
            }
            return 0;
        }
    }
}

