/*
 * Decompiled with CFR 0.152.
 */
package org.acm.seguin.tools.install;

import java.io.PrintWriter;
import java.util.Iterator;
import java.util.LinkedList;
import javax.swing.ButtonGroup;
import javax.swing.JRadioButton;
import org.acm.seguin.tools.install.SettingPanel;
import org.acm.seguin.tools.install.SortSettingPanel;
import org.acm.seguin.util.MissingSettingsException;

public abstract class SortOptionPanel
extends SortSettingPanel {
    private ButtonGroup group = new ButtonGroup();
    private LinkedList list = new LinkedList();

    public String getValue() {
        Iterator iter = this.list.iterator();
        while (iter.hasNext()) {
            Object[] pair = (Object[])iter.next();
            if (!((JRadioButton)pair[1]).isSelected()) continue;
            return (String)pair[0];
        }
        return "";
    }

    public void addControl() {
        this.findProperty(this.getSortName()).setSelected(true);
    }

    public void reload() {
        this.setSortEnabled(false);
        this.findProperty(this.getSortName()).setSelected(true);
    }

    public void addOption(String key, String descr) {
        this.incrItems();
        this.addDescription("* " + key + " - " + descr, false);
        JRadioButton button = new JRadioButton(descr);
        button.setSelected(key.equals(this.getDefaultValue()));
        ++this.constraints.gridy;
        this.add(button, this.constraints);
        this.group.add(button);
        Object[] pair = new Object[]{key, button};
        this.list.add(pair);
    }

    public void generateSetting(PrintWriter output, int index) {
        this.printDescription(output);
        if (!this.isSortEnabled()) {
            output.print("#");
        }
        output.print("sort." + index + "=" + this.getValue());
        output.println("");
    }

    protected JRadioButton findProperty(String key) {
        Iterator iter;
        try {
            int index = 1;
            while (index < 50) {
                String value = SettingPanel.bundle.getString("sort." + index);
                if (value.startsWith(key)) {
                    this.setOrder(index);
                    iter = this.list.iterator();
                    while (iter.hasNext()) {
                        Object[] pair = (Object[])iter.next();
                        if (!value.equals(pair[0])) continue;
                        this.setSortEnabled(true);
                        return (JRadioButton)pair[1];
                    }
                }
                ++index;
            }
        }
        catch (MissingSettingsException mse) {
            // empty catch block
        }
        this.setSortEnabled(false);
        iter = this.list.iterator();
        Object[] pair = (Object[])iter.next();
        return (JRadioButton)pair[1];
    }
}

