/*
 * Decompiled with CFR 0.152.
 */
package org.acm.seguin.tools.install;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.PrintWriter;
import java.util.Iterator;
import java.util.LinkedList;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.acm.seguin.tools.install.SettingPanel;

public abstract class SortSettingPanel
extends SettingPanel {
    protected GridBagConstraints constraints;
    private JCheckBox enabledCheckbox;
    private LinkedList list;
    private int order;

    public SortSettingPanel() {
        this.setLayout(new GridBagLayout());
        this.constraints = new GridBagConstraints();
        this.constraints.gridx = 0;
        this.constraints.gridy = 0;
        this.constraints.gridwidth = 1;
        this.constraints.gridheight = 1;
        this.constraints.weightx = 1.0;
        this.constraints.weighty = 1.0;
        this.constraints.anchor = 17;
        this.constraints.fill = 0;
        this.constraints.insets = new Insets(0, 0, 0, 0);
        this.constraints.ipadx = 0;
        this.constraints.ipady = 0;
        this.enabledCheckbox = new JCheckBox(this.getSortName() + " Enabled");
        this.enabledCheckbox.setSelected(true);
        this.add(this.enabledCheckbox, this.constraints);
        this.list = new LinkedList();
        this.order = 1000;
    }

    public boolean isSortEnabled() {
        return this.enabledCheckbox.isSelected();
    }

    public String getKey() {
        return "sort";
    }

    public int getOrder() {
        return this.order;
    }

    public abstract void generateSetting(PrintWriter var1, int var2);

    protected void setSortEnabled(boolean way) {
        this.enabledCheckbox.setSelected(way);
        Iterator iter = this.list.iterator();
        while (iter.hasNext()) {
            ((JComponent)iter.next()).setEnabled(way);
        }
    }

    protected void setOrder(int value) {
        this.order = value;
    }

    protected abstract String getSortName();

    public String toString() {
        return this.getSortName();
    }

    protected void addLabel(String value) {
        ++this.constraints.gridy;
        this.add(new JLabel(value), this.constraints);
    }

    protected void add(JComponent comp, GridBagConstraints constraints) {
        super.add((Component)comp, constraints);
        if (this.list != null) {
            this.list.add(comp);
        }
    }

    protected void addListener() {
        this.enabledCheckbox.addChangeListener(new EnabledListener());
    }

    protected void generateSetting(PrintWriter output, int index, String key) {
        this.printDescription(output);
        if (!this.isSortEnabled()) {
            output.print("#");
        }
        output.println("sort." + index + "=" + this.getValue());
    }

    protected String getInitialValue() {
        return "";
    }

    private class EnabledListener
    implements ChangeListener {
        private EnabledListener() {
        }

        public void stateChanged(ChangeEvent e) {
            boolean way = SortSettingPanel.this.enabledCheckbox.isSelected();
            Iterator iter = SortSettingPanel.this.list.iterator();
            while (iter.hasNext()) {
                ((JComponent)iter.next()).setEnabled(way);
            }
        }
    }
}

