/*
 * Decompiled with CFR 0.152.
 */
package org.acm.seguin.tools.install;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.acm.seguin.tools.install.TagLinePanel;

public class TagEditorPanel
extends JPanel {
    private JLabel tagNameLabel = new JLabel("Tag Name:");
    private JTextField tagNameTextField = new JTextField(10);
    private JLabel descriptionLabel = new JLabel("Description:");
    private JTextField descriptionTextField = new JTextField(20);
    private JCheckBox classCheckBox = new JCheckBox("Class");
    private JCheckBox methodCheckBox = new JCheckBox("Method");
    private JCheckBox fieldCheckBox = new JCheckBox("Field");
    private JCheckBox enumCheckBox = new JCheckBox("Enum");
    private JButton updateButton = new JButton("Add/Update");
    private JButton clearButton = new JButton("Delete");

    public TagEditorPanel() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.anchor = 17;
        constraints.fill = 0;
        constraints.insets = new Insets(5, 5, 5, 5);
        constraints.ipadx = 0;
        constraints.ipady = 0;
        constraints.gridx = 0;
        constraints.gridy = 0;
        this.add((Component)this.tagNameLabel, constraints);
        constraints.gridx = 1;
        constraints.gridy = 0;
        this.add((Component)this.tagNameTextField, constraints);
        constraints.gridx = 2;
        constraints.gridy = 0;
        this.add((Component)this.descriptionLabel, constraints);
        constraints.gridx = 3;
        constraints.gridy = 0;
        this.add((Component)this.descriptionTextField, constraints);
        constraints.gridx = 0;
        constraints.gridy = 1;
        this.add((Component)this.classCheckBox, constraints);
        constraints.gridx = 1;
        constraints.gridy = 1;
        this.add((Component)this.methodCheckBox, constraints);
        constraints.gridx = 2;
        constraints.gridy = 1;
        this.add((Component)this.fieldCheckBox, constraints);
        constraints.gridx = 3;
        constraints.gridy = 1;
        this.add((Component)this.enumCheckBox, constraints);
        constraints.gridx = 0;
        constraints.gridy = 2;
        this.add((Component)this.updateButton, constraints);
        constraints.gridx = 1;
        constraints.gridy = 2;
        this.add((Component)this.clearButton, constraints);
    }

    public void load(TagLinePanel tlp) {
        if (tlp == null) {
            this.tagNameTextField.setText("");
            this.descriptionTextField.setText("");
            this.classCheckBox.setSelected(false);
            this.fieldCheckBox.setSelected(false);
            this.methodCheckBox.setSelected(false);
            this.enumCheckBox.setSelected(false);
            return;
        }
        this.tagNameTextField.setText(tlp.getTagName());
        this.descriptionTextField.setText(tlp.getDescription());
        this.classCheckBox.setSelected(tlp.isClassType());
        this.fieldCheckBox.setSelected(tlp.isFieldType());
        this.methodCheckBox.setSelected(tlp.isMethodType());
        this.enumCheckBox.setSelected(tlp.isEnumType());
    }

    public void save(TagLinePanel tlp) {
        tlp.setTagName(this.tagNameTextField.getText());
        tlp.setDescription(this.descriptionTextField.getText());
        tlp.setClassType(this.classCheckBox.isSelected());
        tlp.setMethodType(this.methodCheckBox.isSelected());
        tlp.setFieldType(this.fieldCheckBox.isSelected());
        tlp.setEnumType(this.enumCheckBox.isSelected());
    }

    public void addUpdateListener(ActionListener listener) {
        this.updateButton.addActionListener(listener);
    }

    public void removeUpdateListener(ActionListener listener) {
        this.updateButton.removeActionListener(listener);
    }

    public void addClearListener(ActionListener listener) {
        this.clearButton.addActionListener(listener);
    }

    public void removeClearListener(ActionListener listener) {
        this.clearButton.removeActionListener(listener);
    }

    public String getTagName() {
        return this.tagNameTextField.getText();
    }
}

