/*
 * Decompiled with CFR 0.152.
 */
package org.acm.seguin.tools.install;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.PrintWriter;
import java.util.Iterator;
import java.util.StringTokenizer;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.acm.seguin.tools.install.SettingPanel;
import org.acm.seguin.tools.install.TagEditorPanel;
import org.acm.seguin.tools.install.TagLinePanel;
import org.acm.seguin.tools.install.TagListModel;
import org.acm.seguin.util.MissingSettingsException;

public class TagEditorSettingPanel
extends SettingPanel {
    private JList listBox;
    private TagEditorPanel editor;
    private TagListModel listModel;
    private JButton upButton;
    private JButton downButton;
    private static final int CLASS_TYPE = 1;
    private static final int METHOD_TYPE = 2;
    private static final int FIELD_TYPE = 3;
    private static final int ENUM_TYPE = 3;

    public TagEditorSettingPanel() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridwidth = 2;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.anchor = 17;
        constraints.fill = 0;
        constraints.insets = new Insets(0, 0, 0, 0);
        constraints.ipadx = 0;
        constraints.ipady = 0;
        this.add((Component)new JLabel("The following are javadoc tags that are required by the system."), constraints);
        constraints.gridy = 1;
        this.add((Component)new JLabel("To make the javadoc tag required, add the tag and include the description."), constraints);
        constraints.gridy = 2;
        this.add((Component)new JLabel("Use the up and down buttons to adjust the order that javadoc tags are."), constraints);
        constraints.gridy = 3;
        this.add((Component)new JLabel("sorted in."), constraints);
        constraints.insets = new Insets(5, 5, 5, 5);
        constraints.gridy = 4;
        this.editor = new TagEditorPanel();
        this.editor.addUpdateListener(new UpdateTagListener());
        this.editor.addClearListener(new ClearTagListener());
        this.add((Component)this.editor, constraints);
        this.listModel = new TagListModel();
        this.load();
        this.listBox = new JList(this.listModel);
        this.listBox.addListSelectionListener(new TagListener());
        constraints.gridy = 5;
        constraints.fill = 1;
        this.add((Component)new JScrollPane(this.listBox), constraints);
        constraints.gridwidth = 1;
        constraints.gridy = 6;
        constraints.fill = 0;
        constraints.anchor = 13;
        this.upButton = new JButton("Up");
        this.upButton.addActionListener(new MoveUpListener());
        this.add((Component)this.upButton, constraints);
        constraints.gridx = 1;
        constraints.anchor = 17;
        this.downButton = new JButton("Down");
        this.downButton.addActionListener(new MoveDownListener());
        this.add((Component)this.downButton, constraints);
    }

    public String getKey() {
        return "";
    }

    public void generateSetting(PrintWriter output) {
        StringBuffer classBuffer = new StringBuffer("class.tags=");
        boolean classComma = false;
        StringBuffer methodBuffer = new StringBuffer("method.tags=");
        boolean methodComma = false;
        StringBuffer fieldBuffer = new StringBuffer("field.tags=");
        boolean fieldComma = false;
        StringBuffer enumBuffer = new StringBuffer("enum.tags=");
        boolean enumComma = false;
        output.println("#");
        output.println("#  The following are the tags and the order");
        output.println("#  that are required in javadocs.  If there is");
        output.println("#  description, then they are not required and the");
        output.println("#  system is only specifying the order in which they");
        output.println("#  should appear.  If a description is provided, then");
        output.println("#  the tag is required.");
        output.println("#");
        Iterator iter = this.listModel.iterator();
        while (iter.hasNext()) {
            TagLinePanel tlp = (TagLinePanel)iter.next();
            if (tlp.getDescription().length() > 0) {
                output.println(tlp.getTagName() + ".descr=" + tlp.getDescription());
                output.println("");
            }
            if (tlp.isClassType()) {
                if (classComma) {
                    classBuffer.append(",");
                }
                classBuffer.append(tlp.getTagName());
                classComma = true;
            }
            if (tlp.isMethodType()) {
                if (methodComma) {
                    methodBuffer.append(",");
                }
                methodBuffer.append(tlp.getTagName());
                methodComma = true;
            }
            if (tlp.isFieldType()) {
                if (fieldComma) {
                    fieldBuffer.append(",");
                }
                fieldBuffer.append(tlp.getTagName());
                fieldComma = true;
            }
            if (!tlp.isEnumType()) continue;
            if (enumComma) {
                enumBuffer.append(",");
            }
            enumBuffer.append(tlp.getTagName());
            enumComma = true;
        }
        output.println(classBuffer.toString());
        output.println(methodBuffer.toString());
        output.println(fieldBuffer.toString());
        output.println(enumBuffer.toString());
        output.println(" ");
    }

    private void load() {
        TagLinePanel tlp;
        try {
            this.loadTags(SettingPanel.bundle.getString("class.tags"), 1);
        }
        catch (MissingSettingsException mse) {
            tlp = new TagLinePanel();
            tlp.setTagName("author");
            tlp.setDescription("{0}");
            tlp.setClassType(true);
            this.listModel.add(tlp);
            tlp = new TagLinePanel();
            tlp.setTagName("created");
            tlp.setDescription("{1}");
            this.listModel.add(tlp);
            tlp.setClassType(true);
        }
        try {
            this.loadTags(SettingPanel.bundle.getString("enum.tags"), 3);
        }
        catch (MissingSettingsException mse) {
            tlp = new TagLinePanel();
            tlp.setTagName("author");
            tlp.setDescription("{0}");
            tlp.setEnumType(true);
            this.listModel.add(tlp);
            tlp = new TagLinePanel();
            tlp.setTagName("since");
            tlp.setDescription("{1}");
            this.listModel.add(tlp);
            tlp.setEnumType(true);
        }
        try {
            this.loadTags(SettingPanel.bundle.getString("method.tags"), 2);
            String param = SettingPanel.bundle.getString("param.descr");
            String rtn = SettingPanel.bundle.getString("return.descr");
            String exc = SettingPanel.bundle.getString("exception.descr");
        }
        catch (MissingSettingsException mse) {
            tlp = new TagLinePanel();
            tlp.setTagName("param");
            tlp.setDescription("Description of the Parameter");
            tlp.setMethodType(true);
            this.listModel.add(tlp);
            tlp = new TagLinePanel();
            tlp.setTagName("return");
            tlp.setDescription("Description of the Return Value");
            tlp.setMethodType(true);
            this.listModel.add(tlp);
            tlp = new TagLinePanel();
            tlp.setTagName("exception");
            tlp.setDescription("Description of the Exception");
            tlp.setMethodType(true);
            this.listModel.add(tlp);
        }
        try {
            this.loadTags(SettingPanel.bundle.getString("field.tags"), 3);
        }
        catch (MissingSettingsException missingSettingsException) {
            // empty catch block
        }
    }

    private void loadTags(String tagNames, int type) {
        StringTokenizer tok = new StringTokenizer(tagNames, " \t,");
        while (tok.hasMoreTokens()) {
            String next = tok.nextToken();
            TagLinePanel tlp = this.listModel.find(next);
            if (tlp == null) {
                tlp = new TagLinePanel();
                tlp.setTagName(next);
                this.listModel.add(tlp);
                try {
                    tlp.setDescription(SettingPanel.bundle.getString(next + ".descr"));
                }
                catch (MissingSettingsException mse) {
                    tlp.setDescription("");
                }
            }
            if (type == 1) {
                tlp.setClassType(true);
            }
            if (type == 2) {
                tlp.setMethodType(true);
            }
            if (type == 3) {
                tlp.setFieldType(true);
            }
            if (type != 3) continue;
            tlp.setEnumType(true);
        }
    }

    protected String getInitialValue() {
        return "";
    }

    public void reload() {
        this.listModel.clearAll();
        this.load();
    }

    static {
        CLASS_TYPE = 1;
        METHOD_TYPE = 2;
        FIELD_TYPE = 3;
        ENUM_TYPE = 3;
    }

    public class MoveDownListener
    implements ActionListener {
        public void actionPerformed(ActionEvent evt) {
            int index = TagEditorSettingPanel.this.listBox.getSelectedIndex();
            if (index == TagEditorSettingPanel.this.listModel.getSize() - 1) {
                return;
            }
            TagEditorSettingPanel.this.listModel.swap(index, index + 1);
            TagEditorSettingPanel.this.listBox.setSelectedIndex(index + 1);
        }
    }

    public class MoveUpListener
    implements ActionListener {
        public void actionPerformed(ActionEvent evt) {
            int index = TagEditorSettingPanel.this.listBox.getSelectedIndex();
            if (index == 0) {
                return;
            }
            TagEditorSettingPanel.this.listModel.swap(index, index - 1);
            TagEditorSettingPanel.this.listBox.setSelectedIndex(index - 1);
        }
    }

    public class ClearTagListener
    implements ActionListener {
        public void actionPerformed(ActionEvent evt) {
            String name = TagEditorSettingPanel.this.editor.getTagName();
            TagEditorSettingPanel.this.listModel.remove(name);
        }
    }

    public class UpdateTagListener
    implements ActionListener {
        public void actionPerformed(ActionEvent evt) {
            String name = TagEditorSettingPanel.this.editor.getTagName();
            TagLinePanel tlp = TagEditorSettingPanel.this.listModel.find(name);
            boolean isNew = false;
            if (tlp == null) {
                tlp = new TagLinePanel();
                TagEditorSettingPanel.this.listModel.add(tlp);
                isNew = true;
            }
            TagEditorSettingPanel.this.editor.save(tlp);
            if (isNew) {
                try {
                    TagEditorSettingPanel.this.listBox.setSelectedIndex(0);
                    TagEditorSettingPanel.this.listBox.setListData(new String[]{"Please wait..."});
                    TagEditorSettingPanel.this.listBox.setModel(TagEditorSettingPanel.this.listModel);
                    TagEditorSettingPanel.this.listBox.setSelectedIndex(TagEditorSettingPanel.this.listModel.getSize() - 1);
                }
                catch (Throwable thrown) {
                    thrown.printStackTrace(System.out);
                }
            } else {
                TagEditorSettingPanel.this.listBox.repaint();
            }
        }
    }

    public class TagListener
    implements ListSelectionListener {
        public void valueChanged(ListSelectionEvent e) {
            int index = TagEditorSettingPanel.this.listBox.getSelectedIndex();
            TagLinePanel tlp = (TagLinePanel)TagEditorSettingPanel.this.listModel.getElementAt(index);
            TagEditorSettingPanel.this.editor.load(tlp);
        }
    }
}

