/*
 * Decompiled with CFR 0.152.
 */
package org.acm.seguin.util;

import java.io.File;
import org.acm.seguin.io.DirectoryTreeTraversal;
import org.acm.seguin.io.FileCopy;
import org.acm.seguin.tools.install.RefactoryInstaller;

public class BackupTraversal
extends DirectoryTreeTraversal {
    private String dest;

    public BackupTraversal(String init, String out) {
        super(init);
        this.dest = out.charAt(out.length() - 1) != File.separatorChar ? out + File.separator : out;
    }

    protected boolean isTarget(File currentFile) {
        String filename = currentFile.getName();
        String lowercase = filename.toLowerCase();
        if (!lowercase.endsWith(".java")) {
            return false;
        }
        String classname = lowercase.substring(0, lowercase.length() - 5) + ".class";
        File classFile = new File(currentFile.getParentFile(), classname);
        return classFile.exists();
    }

    protected void visit(File currentFile) {
        String destString = this.getDestination(currentFile);
        File destFile = new File(destString);
        new FileCopy(currentFile, destFile).run();
    }

    protected void arriveAtDir(File current) {
        String currentPath = current.getPath();
        String base = "";
        base = currentPath.startsWith("./") || currentPath.startsWith(".\\") ? currentPath.substring(2) : currentPath;
        this.createDir(this.dest + "src/" + base);
        this.createDir(this.dest + "test/src/" + base);
    }

    private String getDestination(File current) {
        String currentPath;
        String prefix = "src/";
        if (current.getName().startsWith("Test")) {
            prefix = "test/src/";
        }
        if ((currentPath = current.getPath()).startsWith("./") || currentPath.startsWith(".\\")) {
            return this.dest + prefix + currentPath.substring(2);
        }
        return this.dest + prefix + currentPath;
    }

    public static void main(String[] args) {
        new RefactoryInstaller(false).run();
        if (args.length != 2) {
            System.out.println("Syntax:  java BackupTraversal source dest");
            return;
        }
        new BackupTraversal(args[0], args[1]).run();
    }

    private void createDir(String destDir) {
        File destDirFile = new File(destDir);
        if (!destDirFile.exists()) {
            destDirFile.mkdirs();
        }
    }

    private void deleteDir(String destDir) {
        File destDirFile = new File(destDir);
        String[] children = destDirFile.list();
        if (children.length == 0) {
            destDirFile.delete();
        }
    }

    protected void leaveDir(File current) {
        String currentPath = current.getPath();
        String base = "";
        base = currentPath.startsWith("./") || currentPath.startsWith(".\\") ? currentPath.substring(2) : currentPath;
        this.deleteDir(this.dest + "src/" + base);
        this.deleteDir(this.dest + "test/src/" + base);
    }
}

