/*
 * Decompiled with CFR 0.152.
 */
package org.acm.seguin.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import org.acm.seguin.awt.ExceptionPrinter;
import org.acm.seguin.tools.install.RefactoryInstaller;
import org.acm.seguin.util.MissingSettingsException;
import org.acm.seguin.util.NoSettingsFileException;
import org.acm.seguin.util.SettingNotFoundException;
import org.acm.seguin.util.Settings;

public class FileSettings
implements Settings {
    private String app;
    private String type;
    private File file;
    private long lastModified;
    private Properties props;
    private boolean continuallyReload;
    private boolean reloadNow;
    private FileSettings parent;
    private static Hashtable map = null;
    private static File settingsRoot = null;
    private static File refactorySettingsRoot = null;

    public FileSettings(File express) throws MissingSettingsException {
        this.file = express;
        if (!this.file.exists()) {
            throw new NoSettingsFileException(this.app, this.type);
        }
        this.load();
        this.app = express.getParent();
        this.type = express.getName();
        this.continuallyReload = false;
        this.reloadNow = false;
        this.parent = null;
    }

    protected FileSettings(String app, String type) throws MissingSettingsException {
        File directory = new File(FileSettings.getSettingsRoot(), "." + app);
        if (!directory.exists()) {
            directory.mkdirs();
            throw new NoSettingsFileException(app, type);
        }
        this.file = new File(directory, type + ".settings");
        if (!this.file.exists()) {
            throw new NoSettingsFileException(app, type);
        }
        this.load();
        this.app = app;
        this.type = type;
        this.continuallyReload = false;
        this.reloadNow = false;
        this.parent = null;
    }

    public void setContinuallyReload(boolean way) {
        this.continuallyReload = way;
    }

    public void setReloadNow(boolean way) {
        this.reloadNow = way;
        if (this.reloadNow) {
            this.load();
        }
    }

    public Enumeration getKeys() {
        if (!this.isUpToDate()) {
            this.load();
        }
        this.reloadNow = false;
        return this.props.keys();
    }

    public String getString(String code) {
        if (!this.isUpToDate()) {
            this.load();
        }
        this.reloadNow = false;
        String result = this.props.getProperty(code);
        if (result == null && this.parent != null) {
            result = this.parent.getString(code);
        }
        if (result == null) {
            throw new SettingNotFoundException(this.app, this.type, code);
        }
        return result;
    }

    public int getInteger(String code) {
        try {
            return Integer.parseInt(this.getString(code));
        }
        catch (NumberFormatException mfe) {
            throw new SettingNotFoundException(this.app, this.type, code);
        }
    }

    public double getDouble(String code) {
        try {
            Double value = new Double(this.getString(code));
            return value;
        }
        catch (NumberFormatException mfe) {
            throw new SettingNotFoundException(this.app, this.type, code);
        }
    }

    public boolean getBoolean(String code) {
        try {
            Boolean value = new Boolean(this.getString(code));
            return value;
        }
        catch (NumberFormatException mfe) {
            throw new SettingNotFoundException(this.app, this.type, code);
        }
    }

    protected void setParent(FileSettings value) {
        this.parent = value;
    }

    private char getSpecial(char ch) {
        switch (ch) {
            case 'b': {
                return '\b';
            }
            case 'r': {
                return '\r';
            }
            case 'n': {
                return '\n';
            }
            case 'f': {
                return '\f';
            }
            case 't': {
                return '\t';
            }
        }
        return ch;
    }

    private boolean isUpToDate() {
        if (this.continuallyReload || this.reloadNow) {
            return this.lastModified == this.file.lastModified();
        }
        return true;
    }

    private synchronized void load() {
        this.props = new Properties();
        try {
            BufferedReader input = new BufferedReader(new FileReader(this.file));
            String line = input.readLine();
            while (line != null) {
                int equalsAt;
                if (line.length() != 0 && line.charAt(0) != '#' && (equalsAt = line.indexOf(61)) > 0) {
                    String key = line.substring(0, equalsAt);
                    String value = this.unescapeChars(line.substring(equalsAt + 1));
                    this.props.put(key, value);
                }
                line = input.readLine();
            }
            input.close();
        }
        catch (IOException ioe) {
            ExceptionPrinter.print(ioe, false);
        }
        this.setReloadNow(false);
        this.lastModified = this.file.lastModified();
    }

    private String unescapeChars(String value) {
        StringBuffer buffer = new StringBuffer();
        int last = value.length();
        int ndx = 0;
        while (ndx < last) {
            char ch = value.charAt(ndx);
            if (ch == '\\') {
                char nextChar = value.charAt(ndx + 1);
                char result = ' ';
                if (nextChar == 'u') {
                    result = this.unicode(value, ndx);
                    ndx += 5;
                } else if (Character.isDigit(nextChar)) {
                    result = this.octal(value, ndx);
                    ndx += 3;
                } else if (ndx != last - 1) {
                    result = this.getSpecial(nextChar);
                    ++ndx;
                }
                buffer.append(result);
            } else {
                buffer.append(ch);
            }
            ++ndx;
        }
        return buffer.toString();
    }

    private char unicode(String value, int ndx) {
        String hex = value.substring(ndx + 2, ndx + 6);
        int result = Integer.parseInt(hex, 16);
        return (char)result;
    }

    private char octal(String value, int ndx) {
        String oct = value.substring(ndx + 1, ndx + 4);
        int result = Integer.parseInt(oct, 8);
        return (char)result;
    }

    public static void setSettingsRoot(String dir) {
        settingsRoot = new File(dir);
        refactorySettingsRoot = null;
    }

    public static void setSettingsRoot(File dir) {
        settingsRoot = dir;
        refactorySettingsRoot = null;
    }

    public static FileSettings getSettings(String app, String name) {
        String key;
        FileSettings result;
        if (map == null) {
            FileSettings.init();
        }
        if ((result = (FileSettings)map.get(key = app + "::" + name)) == null) {
            result = new FileSettings(app, name);
            map.put(key, result);
        }
        return result;
    }

    public static FileSettings getRefactorySettings(String name) {
        return FileSettings.getSettings("Refactory", name);
    }

    public static FileSettings getRefactoryPrettySettings() {
        return FileSettings.getSettings("Refactory", "pretty");
    }

    public static File getRefactorySettingsRoot() {
        if (refactorySettingsRoot == null) {
            refactorySettingsRoot = new File(settingsRoot, ".Refactory");
        }
        return refactorySettingsRoot;
    }

    public static File getSettingsRoot() {
        if (settingsRoot == null) {
            FileSettings.initRootDir();
        }
        return settingsRoot;
    }

    public static void main(String[] args) {
        new RefactoryInstaller(false).run();
        String key = "author";
        if (args.length > 0) {
            key = args[0];
        }
        String type = "pretty";
        if (args.length > 1) {
            type = args[1];
        }
        String app = "Refactory";
        if (args.length > 2) {
            app = args[2];
        }
        System.out.println("Found:  " + new FileSettings(app, type).getString(key));
    }

    private static synchronized void init() {
        if (map == null) {
            map = new Hashtable();
            FileSettings.initRootDir();
        }
    }

    private static void initRootDir() {
        File attempt;
        if (settingsRoot != null) {
            return;
        }
        String javaHome = System.getProperty("jrefactory.home");
        if (javaHome != null) {
            settingsRoot = new File(javaHome);
            return;
        }
        javaHome = System.getProperty("user.home");
        if (javaHome != null) {
            settingsRoot = new File(javaHome);
            return;
        }
        settingsRoot = new File("~/");
        if (settingsRoot.exists()) {
            return;
        }
        settingsRoot = new File("C:\\winnt\\profiles");
        if (settingsRoot.exists() && (attempt = new File(settingsRoot, System.getProperty("user.name"))).exists()) {
            settingsRoot = attempt;
            return;
        }
        settingsRoot = new File("c:\\windows");
    }

    public File getFile() {
        return this.file;
    }
}

